package com.ejie.aa17a.control;

import java.util.List;
import java.util.Properties;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.aa17a.model.Aa17aEstacion;
import com.ejie.aa17a.model.geojson.Aa17aGeojson;
import com.ejie.aa17a.service.iface.Aa17aEstacionService;
import com.ejie.aa17a.utilidades.Aa17aConstantes;

/**
 * Aa17aEstacionController generated by UDA, 18-dic-2013 15:36:30.
 * 
 * @author UDA
 */

@RequestMapping(value = "/estacion")
public class Aa17aEstacionController {

	private static final Logger logger = LoggerFactory.getLogger(Aa17aEstacionController.class);

	private Aa17aEstacionService aa17aEstacionService;
	private Properties appConfiguration;

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterAa17aEstacion
	 *            Aa17aEstacion
	 * @return List
	 */
	@RequestMapping(value = "lista", method = RequestMethod.GET)
	public @ResponseBody
	List<Aa17aEstacion> getAll(@ModelAttribute Aa17aEstacion filterAa17aEstacion) {
		Aa17aEstacionController.logger.info("[GET - find_ALL] : Obtener Aa17aEstacion por filtro");
		return this.aa17aEstacionService.findAll(filterAa17aEstacion);
	}

	/**
	 * Method 'getCreateFormMapa'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "mapa", method = RequestMethod.GET)
	public ModelAndView getCreateFormMapa(Model model) {
		Aa17aEstacionController.logger.info("[GET - View] : getCreateFormMapa");

		model.addAttribute("staticsGisUrl", this.appConfiguration.get(Aa17aConstantes.CONFIG_STATICS_GIS_URL));
		model.addAttribute("staticsGisSbUrl", this.appConfiguration.get(Aa17aConstantes.CONFIG_STATICS_GIS_SB_URL));

		return new ModelAndView("mapa", "model", model);
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @return List
	 */
	@RequestMapping(value = "geojson", method = RequestMethod.GET)
	public @ResponseBody
	Aa17aGeojson getGeojson() {
		Aa17aEstacionController.logger.info("[GET - find_ALL] : Obtener Aa17aEstacion por filtro");

		Aa17aEstacion filterAa17aEstacion = new Aa17aEstacion();
		filterAa17aEstacion.setEstado(Aa17aConstantes.ESTADO_ACTIVO);
		return this.aa17aEstacionService.getGeojsonMapa(filterAa17aEstacion);
	}

	/**
	 * Method 'setAa17aEstacionService'.
	 * 
	 * @param aa17aEstacionService
	 *            Aa17aEstacionService
	 * @return
	 */
	public void setAa17aEstacionService(Aa17aEstacionService aa17aEstacionService) {
		this.aa17aEstacionService = aa17aEstacionService;
	}

	/**
	 * @param appConfiguration
	 *            the appConfiguration to set
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

}
